/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.modifiers.upgrades.general.ReinforcedModifier;

public class TenacityModifier
extends Modifier {
    public int onDamageTool(IToolStackView tool, int level, int amount, @Nullable LivingEntity holder) {
        int current = tool.getCurrentDurability();
        if ((double)current <= (double)((Float)tool.getStats().get((IToolStat)ToolStats.DURABILITY)).floatValue() * 0.4) {
            float percentage = (float)current / ((Float)tool.getStats().get((IToolStat)ToolStats.DURABILITY)).floatValue();
            if (percentage >= 0.1f) {
                return ReinforcedModifier.damageReinforced((int)amount, (float)(1.0f / percentage / 20.0f + 0.05f * (float)(level - 1)));
            }
            return ReinforcedModifier.damageReinforced((int)amount, (float)(0.5f + 0.05f * (float)(level - 1)));
        }
        return amount;
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        int current;
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if ((harvest || tool.hasTag(TinkerTags.Items.RANGED)) && player != null && key == TooltipKey.SHIFT && (float)(current = tool.getCurrentDurability()) <= ToolStats.DURABILITY.getMaxValue() * 0.4f) {
            float percentage = (float)current / ToolStats.DURABILITY.getMaxValue();
            if (percentage >= 0.1f) {
                this.addPercentTooltip((Component)new TranslatableComponent("modifier.tinkerscalibration.tenacity.unbreaking"), 1.0f / percentage / 20.0f + 0.05f * (float)(level - 1), tooltip);
            } else {
                this.addPercentTooltip((Component)new TranslatableComponent("modifier.tinkerscalibration.tenacity.unbreaking"), 0.5f + 0.05f * (float)(level - 1), tooltip);
            }
        }
    }
}

